


//--------------------------------------------------------------------------------------
// Global variables
//--------------------------------------------------------------------------------------
Texture2D overlay;            //

int mode;
float    g_fTime;                   // App's time in seconds
int overlay_Width;
int overlay_Height;
int dst_Width;
int dst_Height;


//--------------------------------------------------------------------------------------
// Texture samplers
//--------------------------------------------------------------------------------------
SamplerState TextureSampler
{
    Filter = MIN_MAG_MIP_NEAREST;
    AddressU = Wrap;
    AddressV = Wrap;
};

struct VS_INPUT
{
    float4 Position   : POSITION; // vertex position 
    float2 TextureUV  : TEXCOORD0;   // vertex texture coords 
};

struct VS_OUTPUT
{
    float4 Position   : SV_POSITION; // vertex position 
    float2 TextureUV  : TEXCOORD1;   // vertex texture coords 
};

//--------------------------------------------------------------------------------------
// Pixel shader output structure
//--------------------------------------------------------------------------------------
struct PS_OUTPUT
{
    float4 RGBColor : SV_Target;  // Pixel color
};


//--------------------------------------------------------------------------------------
// This shader outputs the pixel's color by modulating the texture's
//       color with diffuse material color
//--------------------------------------------------------------------------------------

#define EQN_EPS 1e-9f

static bool isZero(float x) {
	return (x > -EQN_EPS && x < EQN_EPS);
}

PS_OUTPUT PS_2D( VS_OUTPUT In)
{ 
    PS_OUTPUT Output;
    int width = overlay_Width;
    int height = overlay_Height;
    float ow = float(overlay_Width);
    float oh = float(overlay_Height);
    float bw = float(dst_Width);
    float bh = float(dst_Height);
    float2 tc = In.TextureUV;
    
    float4 img = overlay.Sample(TextureSampler, tc) * 255.0f;
    float4 yuv = float4(0.0,0.0,0.0,0.0); 
    img.xyz = img.zyx;
    
    //bt709
    yuv.x = 0.1825 * img.z + 0.6142 * img.y + 0.0620 * img.x + 16.0;
    yuv  = yuv / 255.0;
	Output.RGBColor = yuv;

    return Output;

}

// 
VS_OUTPUT VS_2D(VS_INPUT vin)
{
	VS_OUTPUT vOut;
	vOut.Position = vin.Position;
	vOut.TextureUV = vin.TextureUV;
	return vOut;
}

//--------------------------------------------------------------------------------------
// Renders scene to render target using D3D11 Techniques
//--------------------------------------------------------------------------------------
technique11 ColorTech
{
	pass P0
	{
		SetVertexShader(CompileShader(vs_4_0, VS_2D()));
		SetPixelShader(CompileShader(ps_4_0, PS_2D()));

	}
}

